<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->index('status', 'bookings_status_index');
        });

        Schema::table('booking_items', function (Blueprint $table) {
            $table->index('status', 'booking_items_status_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropIndex('bookings_status_index');
        });

        Schema::table('booking_items', function (Blueprint $table) {
            $table->dropIndex('booking_items_status_index');
        });
    }
};
