<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_provider_id')->constrained('service_providers');
            $table->foreignId('category_id')->nullable()->constrained('categories');
            $table->enum('type', ['service', 'package']);
            $table->string('name_en', 100);
            $table->string('name_ar', 100);
            $table->string('description_en')->nullable();
            $table->string('description_ar')->nullable();
            $table->text('details_en');
            $table->text('details_ar');
            $table->decimal('price', 10, 2);
            $table->decimal('price_before_discount', 10, 2)->nullable();
            $table->string('location_url')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
