<?php

namespace App\Policies;

use App\Models\Admin;
use App\Models\Product;
use App\Models\ServiceProvider;
use Illuminate\Auth\Access\HandlesAuthorization;

class ProductPolicy
{
    use HandlesAuthorization;

    public function view(ServiceProvider|Admin $provider, Product $product)
    {
        return class_basename(auth('admin')->user()) === 'Admin' || $provider->id === $product->service_provider_id;
    }

    public function update(ServiceProvider|Admin $provider, Product $product)
    {
        return class_basename(auth('admin')->user()) === 'Admin' || $provider->id === $product->service_provider_id;
    }

    public function delete(ServiceProvider|Admin $provider, Product $product)
    {
        return class_basename(auth('admin')->user()) === 'Admin' || $provider->id === $product->service_provider_id;
    }
}
