<?php

namespace App\Observers;

use App\Models\ServiceProvider;
use App\Mail\AccountActivated;
use Illuminate\Support\Facades\Mail;

class ServiceProviderObserver
{
    /**
     * Handle the ServiceProvider "created" event.
     */
    public function created(ServiceProvider $serviceProvider): void
    {
        //
    }

    /**
     * Handle the ServiceProvider "updated" event.
     */
    public function updated(ServiceProvider $serviceProvider): void
    {
        if (
            $serviceProvider->isDirty('is_active')
            && $serviceProvider->is_active
            && $serviceProvider->isDirty('commission_rate')
            && $serviceProvider->getOriginal('commission_rate') === null
        ) {
            Mail::to($serviceProvider->email)->send(new AccountActivated($serviceProvider));
        }
    }

    /**
     * Handle the ServiceProvider "deleted" event.
     */
    public function deleted(ServiceProvider $serviceProvider): void
    {
        //
    }

    /**
     * Handle the ServiceProvider "restored" event.
     */
    public function restored(ServiceProvider $serviceProvider): void
    {
        //
    }

    /**
     * Handle the ServiceProvider "force deleted" event.
     */
    public function forceDeleted(ServiceProvider $serviceProvider): void
    {
        //
    }
}
