<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use NotificationChannels\Twilio\TwilioSmsMessage;

class ForgetPasswordSMSNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $name;
    public $phone;
    public $code;

    /**
     * Create a new notification instance.
     */
    public function __construct($name, $phone, $code)
    {
        $this->name = $name;
        $this->phone = $phone;
        $this->code = $code;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return [];
    }

    /**
     * Get the Twilio SMS representation of the notification.
     */
    public function toTwilio(object $notifiable): TwilioSmsMessage
    {
        return (new TwilioSmsMessage())
            ->content("Hello {$this->name}, Your password reset code is: {$this->code}. This code will expire in 10 minutes.");
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
