<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ForgetPasswordEmailNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $name;
    public $email;
    public $code;

    /**
     * Create a new notification instance.
     */
    public function __construct($name, $email, $code)
    {
        $this->name = $name;
        $this->email = $email;
        $this->code = $code;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Forget Password Code - ' . $this->code)
            ->greeting('Hello ' . $this->name . ',')
            ->line('You are receiving this email because we received a password reset request for your account.')
            ->line('Your password reset code is: ' . $this->code)
            ->line('This code will expire in 10 minutes.')
            // ->action('Reset Password', url('/reset-password?email=' . $this->email . '&code=' . $this->code))
            ->line('If you did not request a password reset, no further action is required.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
