<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $acceptLanguage = $request->header('Accept-Language', 'en');
        $locale = in_array($acceptLanguage, ['ar', 'en']) ? $acceptLanguage : 'en';

        $valueEn = is_string($this->value_en ?? null) ? json_decode($this->value_en, true) : ($this->value_en ?? []);
        $valueAr = is_string($this->value_ar ?? null) ? json_decode($this->value_ar, true) : ($this->value_ar ?? []);

        $localizedContent = ($locale === 'ar') ? $valueAr : $valueEn;

        // Merge localized content with untranslatable contact info (always from English for consistency)
        return [
            'about_us' => html_entity_decode(strip_tags($localizedContent['about_us']) ?? null),
            'terms_and_conditions' => html_entity_decode(strip_tags($localizedContent['terms_and_conditions'])) ?? null,
            'privacy_policy' => html_entity_decode(strip_tags($localizedContent['privacy_policy'])) ?? null,
            // 'payment_description' => html_entity_decode(strip_tags($localizedContent['payment_description'])) ?? null,
            // 'app_fee' => $valueEn['app_fee'] ?? null,
            // 'app_bank_name' => $valueEn['app_bank_name'] ?? null,
            // 'app_bank_user_name' => $valueEn['app_bank_user_name'] ?? null,
            // 'app_bank_iban' => $valueEn['app_bank_iban'] ?? null,
            'contact_phone' => $valueEn['contact_phone'] ?? null, // Untranslatable, always from English
            'cancellation_window' => $valueEn['contact_phone'] ?? 24,
            'contact_email' => $valueEn['contact_email'] ?? null, // Untranslatable, always from English
            'social_facebook' => $valueEn['social_facebook'] ?? null, // Untranslatable, always from English
            'social_x' => $valueEn['social_x'] ?? null, // Untranslatable, always from English
            'social_instagram' => $valueEn['social_instagram'] ?? null, // Untranslatable, always from English
            'social_snapchat' => $valueEn['social_snapchat'] ?? null, // Untranslatable, always from English
            'social_tiktok' => $valueEn['social_tiktok'] ?? null, // Untranslatable, always from English
        ];
    }
}
