<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $data = $this->data;
        return [
            'id' => $this->id,
            'type' => str($this->type)->replace('App\\Notifications\\', ''),
            'title' => $data['title_' . app()->getLocale()] ?? null,
            'body' => $data['body_' . app()->getLocale()] ?? null,
            'url' => $data['url'] ?? null,
            'booking_id' => $data['booking_id'] ?? null,
            'read_at' => $this->read_at,
            'created_at' => $this->created_at,
        ];
    }
}
