<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'booking_id' => $this->booking_id,
            'price' => $this->price,
            'service_date' => $this->service_date,
            'service_provider_id' => $this->service_provider_id,
            'service_provider' => new ServiceProviderResource($this->whenLoaded('serviceProvider')),
            'product' => new ProductResource($this->whenLoaded('product')),
            'user' => new UserResource($this->whenLoaded('user')),
            'status' => $this->status,
            "is_transfered" => $this->is_transfered,
            'notes' => $this->notes,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
        if (class_basename(auth()->user()) == 'ServiceProvider') {
            $data['commission'] = $this->commission;
            $data['net_price'] = $this->net_price;
        }
        $data['activities'] = $this->whenLoaded('activities', default: []);

        return $data;
    }
}
