<?php

namespace App\Http\Requests\Api\Provider;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class UpdateProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $provider = Auth::user();
        $rules = [
            'category_id' => ['required', Rule::exists('categories', 'id')->where('is_active', true)],
            'name' => ['required', 'string', 'min:4', 'max:100'],
            // 'email' => ['required', 'email', Rule::unique('service_providers', 'email')->ignore($provider->id)],
            // 'phone' => ['required', 'numeric', "starts_with:9665", 'digits:12', Rule::unique('service_providers', 'phone')->ignore($provider->id)],
            'nationality_id' => ['required', 'numeric', Rule::exists('nationalities', 'id')->where('is_active', true)],
            'cities' => ['required', 'array', 'distinct', 'min:1'],
            'cities.*' => [Rule::exists('cities', 'id')->where('is_active', true)],
            'logo' => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ];

        return $rules;
    }
}
