<?php

namespace App\Http\Requests\Api\Provider;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation.
     *
     * @return void
     */
    protected function prepareForValidation()
    {
        if (!$this->has('availabilities')) {
            $this->merge([
                'availabilities' => [],
            ]);
        } elseif (is_array($this->input('availabilities'))) {
            $this->merge([
                'availabilities' => array_filter($this->input('availabilities')),
            ]);
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $rules =  [
            'type' => 'required|in:service,package',
            'name_en' => 'required|string|max:100',
            'name_ar' => 'required|string|max:100',
            'details_en' => 'required|string',
            'details_ar' => 'required|string',
            'price' => 'required|numeric|max:99999999.99',
            'price_before_discount' => 'nullable|numeric|max:99999999.99|min:' . $this->input('price'),
            'location_url' => 'nullable|url',
            'images' => ['required', 'array', 'max:4'],
            'images.*' => 'file|mimes:jpg,png,webp|max:5120',
            'cities' => ['required', 'array', Rule::when($this->type === 'service', 'size:1')],
            'cities.*' => [Rule::exists('cities', 'id')->where('is_active', 1)],
            'availabilities' => 'present|array',
            'availabilities.*' => 'distinct|date_format:Y-m-d|after_or_equal:today',
        ];
        if ($this->input('type') == 'service') {
            $rules['description_en'] = 'required|string|max:255';
            $rules['description_ar'] = 'required|string|max:255';
            $rules['videos'] = ["nullable", 'array', 'max:4'];
            $rules['videos.*'] = 'file|mimes:mp4|max:5120';
            $rules['category_id'] = ['required', Rule::exists('categories', 'id')->where('is_active', 1)];
        }

        return $rules;
    }
}
