<?php

namespace App\Http\Controllers;

use OpenApi\Annotations as OA;

/**
 * @OA\OpenApi(
 *     @OA\Info(
 *         version="1.0.0",
 *         title="Momento API",
 *         description="API documentation for the Momento application.",
 *         @OA\Contact(
 *             email="support@momento.com"
 *         )
 *     ),
 *     @OA\Server(
 *         url=L5_SWAGGER_CONST_HOST,
 *         description="Momento API Server"
 *     ),
 *     @OA\Components(
 *         @OA\Parameter(
 *             parameter="AcceptLanguage",
 *             name="Accept-Language",
 *             in="header",
 *             required=false,
 *             description="Language preference (e.g., en, ar)",
 *             @OA\Schema(
 *                 type="string",
 *                 enum={"en", "ar"},
 *                 default="en"
 *             )
 *         ),
 *         @OA\Schema(
 *          schema="UserBookingResource",
 *          title="User Booking Resource",
 *          description="Booking resource for a user",
 *          @OA\Property(property="id", type="integer", example=1),
 *          @OA\Property(property="total_amount", type="number", format="float", example=100.50),
 *          @OA\Property(property="payment_method", type="string", example="cash"),
 *          @OA\Property(property="payment_status", type="string", example="pending"),
 *          @OA\Property(property="created_at", type="string", format="date-time"),
 *          @OA\Property(property="updated_at", type="string", format="date-time"),
 *          @OA\Property(property="notes", type="string", nullable=true, example="Some notes"),
 *          @OA\Property(property="status", type="string", example="pending"),
 *          @OA\Property(property="user", ref="#/components/schemas/UserResource"),
 *          @OA\Property(property="items", type="array", @OA\Items(ref="#/components/schemas/BookingItemResource"))
 *          ),
 *         @OA\Schema(
 *             schema="BookingResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="total_amount", type="number", format="float"),
 *             @OA\Property(property="commission_amount", type="number", format="float"),
 *             @OA\Property(property="net_amount", type="number", format="float"),
 *             @OA\Property(property="payment_method", type="string"),
 *             @OA\Property(property="payment_status", type="string"),
 *             @OA\Property(property="notes", type="string"),
 *             @OA\Property(property="status", type="string"),
 *             @OA\Property(property="user", ref="#/components/schemas/UserResource"),
 *             @OA\Property(property="items", type="array", @OA\Items(ref="#/components/schemas/BookingItemResource"))
 *         ),
 *         @OA\Schema(
 *             schema="BookingItemResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="price", type="number", format="float"),
 *             @OA\Property(property="service_date", type="string", format="date"),
 *             @OA\Property(property="product", oneOf={@OA\Schema(ref="#/components/schemas/ServiceResource"), @OA\Schema(ref="#/components/schemas/PackageResource")})
 *         ),
 *         @OA\Schema(
 *             schema="CartItemResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="product", oneOf={@OA\Schema(ref="#/components/schemas/ServiceResource"), @OA\Schema(ref="#/components/schemas/PackageResource")})
 *         ),
 *         @OA\Schema(
 *             schema="CategoryResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="name", type="string")
 *         ),
 *         @OA\Schema(
 *             schema="CityResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="name", type="string")
 *         ),
 *         @OA\Schema(
 *             schema="FavoriteResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="product", oneOf={@OA\Schema(ref="#/components/schemas/ServiceResource"), @OA\Schema(ref="#/components/schemas/PackageResource")})
 *         ),
 *         @OA\Schema(
 *             schema="PackageResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="type", type="string"),
 *             @OA\Property(property="name", type="string"),
 *             @OA\Property(property="details", type="string"),
 *             @OA\Property(property="price", type="number", format="float"),
 *             @OA\Property(property="price_before_discount", type="number", format="float"),
 *            @OA\Property(property="avg_rating", type="float"),
 *             @OA\Property(property="location_url", type="string"),
 *             @OA\Property(property="is_active", type="boolean"),
 *             @OA\Property(property="cities", type="array", @OA\Items(ref="#/components/schemas/CityResource")),
 *             @OA\Property(property="availabilities", type="array", @OA\Items(type="string", format="date")),
 *             @OA\Property(property="booked_dates", type="array", @OA\Items(type="string", format="date"))
 *         ),
 *         @OA\Schema(
 *             schema="ServiceResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="type", type="string"),
 *             @OA\Property(property="name", type="string"),
 *             @OA\Property(property="description", type="string"),
 *             @OA\Property(property="details", type="string"),
 *             @OA\Property(property="price", type="number", format="float"),
 *             @OA\Property(property="price_before_discount", type="number", format="float"),
 *             @OA\Property(property="avg_rating", type="float"),
 *             @OA\Property(property="location_url", type="string"),
 *             @OA\Property(property="is_active", type="boolean"),
 *             @OA\Property(property="category", ref="#/components/schemas/CategoryResource"),
 *             @OA\Property(property="cities", type="array", @OA\Items(ref="#/components/schemas/CityResource")),
 *             @OA\Property(property="availabilities", type="array", @OA\Items(type="string", format="date")),
 *             @OA\Property(property="booked_dates", type="array", @OA\Items(type="string", format="date"))
 *         ),
 *         @OA\Schema(
 *             schema="ServiceProviderResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="name", type="string"),
 *             @OA\Property(property="email", type="string"),
 *             @OA\Property(property="phone", type="string"),
 *             @OA\Property(property="is_active", type="boolean")
 *         ),
 *         @OA\Schema(
 *             schema="UserResource",
 *             type="object",
 *             @OA\Property(property="id", type="integer"),
 *             @OA\Property(property="first_name", type="string"),
 *             @OA\Property(property="last_name", type="string"),
 *             @OA\Property(property="email", type="string"),
 *             @OA\Property(property="phone", type="string")
 *         ),
 *          @OA\Schema(
 *              schema="NationalityResource",
 *              title="Nationality Resource",
 *              description="Nationality resource",
 *              @OA\Property(
 *                  property="id",
 *                  type="integer",
 *                  format="int64",
 *                  example=1
 *              ),
 *              @OA\Property(
 *                  property="name",
 *                  type="string",
 *                  example="Egyptian"
 *              ),
 *          ),
 *   @OA\Schema(
 *     schema="NotificationResource",
 *     title="Notification Resource",
 *     description="Notification resource",
 *     @OA\Property(property="id", type="string", format="uuid", example="0e57b88b-416e-4a37-80de-a0b3450f2b9c"),
 *     @OA\Property(property="type", type="string", example="PromotionNotification"),
 *     @OA\Property(property="title", type="string", example="1"),
 *     @OA\Property(property="body", type="string", example="3"),
 *     @OA\Property(property="url", type="string", nullable=true, example=null),
 *     @OA\Property(property="read_at", type="string", format="date-time", nullable=true, example=null),
 *     @OA\Property(property="created_at", type="string", format="date-time", example="2025-10-02T22:19:57.000000Z")
 * ),
 *          @OA\Schema(
 *              schema="ReviewResource",
 *              title="Review Resource",
 *              description="Review resource",
 *              @OA\Property(
 *                  property="id",
 *                  type="integer",
 *                  example=1
 *              ),
 *              @OA\Property(
 *                  property="rating",
 *                  type="integer",
 *                  example=5
 *              ),
 *              @OA\Property(
 *                  property="comment",
 *                  type="string",
 *                  example="Great product!"
 *              ),
 *          ),
 *          @OA\Schema(
 *              schema="App_Http_Resources_Api_SettingResource",
 *              title="Setting Resource",
 *              description="Resource for application settings",
 *              @OA\Property(property="about_us", type="string", example="About us content in HTML format."),
 *              @OA\Property(property="terms_and_conditions", type="string", example="Terms and conditions content in HTML format."),
 *              @OA\Property(property="privacy_policy", type="string", example="Privacy policy content in HTML format."),
 *              @OA\Property(property="cancellation_window", type="integer", example="24"),
 *              @OA\Property(property="contact_phone", type="string", example="+966500000000"),
 *              @OA\Property(property="contact_email", type="string", format="email", example="info@example.com"),
 *              @OA\Property(property="social_facebook", type="string", example="https://facebook.com/example"),
 *              @OA\Property(property="social_x", type="string", example="https://twitter.com/example"),
 *              @OA\Property(property="social_instagram", type="string", example="https://instagram.com/example"),
 *              @OA\Property(property="social_snapchat", type="string", example="https://snapchat.com/example"),
 *              @OA\Property(property="social_tiktok", type="string", example="https://tiktok.com/example")
 *          ),
 *          @OA\Schema(
 *              schema="BannerResource",
 *              title="Banner Resource",
 *              description="Banner resource",
 *              @OA\Property(property="id", type="integer", example=1),
 *              @OA\Property(property="url", type="string", example="https://example.com"),
 *              @OA\Property(property="image", type="string", example="https://example.com/image.jpg")
 *          ),
 *          @OA\SecurityScheme(
 *              securityScheme="bearerAuth",
 *              type="http",
 *              scheme="bearer"
 *          )
 *     )
 * )
 */

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

abstract class Controller
{
    use AuthorizesRequests;
}
