<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\BannerResource;
use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    /**
     * @OA\Get(
     *      path="/api/banners",
     *      operationId="getBanners",
     *      tags={"Public"},
     *      summary="Get list of banners",
     *      description="Returns list of banners",
     *      @OA\Parameter(
     *         name="Accept-Language",
     *         in="header",
     *         required=false,
     *         description="Language preference (e.g., 'en', 'ar')",
     *         @OA\Schema(type="string", enum={"en", "ar"}, default="en")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\JsonContent(type="array", @OA\Items(ref="#/components/schemas/BannerResource"))
     *       ),
     * )
     */
    public function index()
    {
        $banners = Banner::where('is_active', true)
            ->where('locale', app()->getLocale())
            ->orderBy('order_column')
            ->get();

        return BannerResource::collection($banners);
    }
}
